function unarchive(item, itemName)
    if type(item) ~= 'table' then
        return item
    end
    local typeName, properties = item[1], item[2]
    if type(typeName) ~= 'string' then
        if itemName then
            error('Could not unarchive object \'' .. tostring(itemName) .. '\' with ' .. type(typeName) .. ' type name.')
        else
            error('Could not unarchive object with ' .. type(typeName) .. ' type name.')
        end
    end
    local constructor = tryGlobal('_' .. typeName)
    if type(constructor) == 'function' then
        return constructor(properties or {})
    end
    local class = tryGlobal(typeName)
    if (type(class) == 'table' or type(class) == 'userdata') and class.new then
        local object = class:new()
        object:notUndoably(function()
            object:initialize(properties)
        end)
        unarchived(object)
        return object
    end
    error('Could not unarchive object of type \'' .. tostring(typeName) .. '\'.')
end

return unarchive
